
checked = false
mod_plr = {}

FRAME_RATE = 60

-- format: { <beat>, <command> }
local LuaMods = {
{4, 'Intro1'},
{19, 'Intro1Leaves'},
{20, 'Intro2'},
{35, 'Intro2Leaves'},
{36, 'Intro3'},
{51, 'Intro3Leaves'},
{68, 'Hardtek'},
{68, 'BPM200'},
{72, 'HardtekLeaves'},
{72, 'BPM200Leaves'},
{84, 'Frenchcore'},
{84, 'BPM200'},
{88, 'FrenchcoreLeaves'},
{88, 'BPM200Leaves'},
{100, 'Artcore'},
{100, 'BPM200'},
{104, 'ArtcoreLeaves'},
{104, 'BPM200Leaves'},
{116, 'Metal'},
{116, 'BPM200'},
{120, 'MetalLeaves'},
{120, 'BPM200Leaves'},
{180, 'WhiteBG'},
{196, 'WhiteBGLeaves'},
{216, 'Complextro'},
{216, 'BPM132'},
{220, 'ComplextroLeaves'},
{220, 'BPM132Leaves'},
{248, 'MelodicProgessiveHouse'},
{248, 'BPM132Melodic'},
{252, 'MelodicProgessiveHouseLeaves'},
{252, 'BPM132Leaves'},
{280, 'Trance'},
{280, 'BPM140'},
{284, 'TranceLeaves'},
{284, 'BPM140Leaves'},
{312, 'PsychedelicTrance'},
{312, 'BPM150'},
{316, 'PsychedelicTranceLeaves'},
{316, 'BPM150Leaves'},
{344, 'Hardstyle'},
{344, 'BPM150'},
{348, 'HardstyleLeaves'},
{348, 'BPM150Leaves'},
{360, 'Psystyle'},
{360, 'BPM150'},
{364, 'PsystyleLeaves'},
{364, 'BPM150Leaves'},
{376, 'Dubstep'},
{376, 'BPM150'},
{380, 'DubstepLeaves'},
{380, 'BPM150Leaves'},
{392, 'ColourBass'},
{392, 'BPM150Black'},
{396, 'ColourBassLeaves'},
{396, 'BPM150BlackLeaves'},
{408, 'HiTechFullOn'},
{408, 'BPM160'},
{412, 'HiTechFullOnLeaves'},
{412, 'BPM160Leaves'},
{424, 'JukeFootwork'},
{424, 'BPM160'},
{428, 'JukeFootworkLeaves'},
{428, 'BPM160Leaves'},
{440, 'LofiHipHop'},
{440, 'BPM80'},
{442, 'LofiHipHopLeaves'},
{442, 'BPM80Leaves'},
{456, 'KawaiiFutureBass'},
{456, 'BPM170'},
{460, 'KawaiiFutureBassLeaves'},
{460, 'BPM170Leaves'},
{488, 'Drumstep'},
{488, 'BPM180'},
{492, 'DrumstepLeaves'},
{492, 'BPM180Leaves'},
{520, 'WhiteFlash'},
{584, 'Hardcore'},
{584, 'BPM200'},
{592, 'HardcoreLeaves'},
{592, 'BPM200Leaves'},
{712, 'WhiteBG2'},
{736, 'BlackScreen'},
}

local function TimeInBeats(beats,bpm)
  return 60 / bpm * beats
  end;

-- EASING --
local path = GAMESTATE:GetCurrentSong():GetSongDir()..'lua/'
loadfile(path..'easing.lua')()
loadfile(path..'modhelpers.lua')()
loadfile(path.."mods.lua")()

local function Plr(pn)
	if GAMESTATE:IsPlayerEnabled(pn-1) then
		return SCREENMAN:GetTopScreen():GetChild('PlayerP'..pn)
	else
		return nil
	end
end
function GetJud(pn)
	return _G['jud'..pn]
end
function GetCom(pn)
	return _G['com'..pn]
end


function mod_do(str,pn)
	if pn then
		if GAMESTATE:IsPlayerEnabled(pn-1) then
			taronuke_mods(str,pn)
		end
	else
		for pn=1,2 do
			if GAMESTATE:IsPlayerEnabled(pn-1) then
				taronuke_mods(str,pn)
			end
		end
	end
end

-- ALIASES --
--These make it so the syntax for the table entries matches the syntax for the nITG template.
--If you want to prefix all your calls with "modhelpers.", "ease.", etc., then you won't need this and can remove this section.
local linear, inQuad, outQuad, inOutQuad, outInQuad, inCubic, outCubic, inOutCubic, outInCubic, inQuart,outQuart, inOutQuart, outInQuart, inQuint, outQuint, inOutQuint, outInQuint, inSine, outSine, inOutSine,outInSine, inExpo, outExpo, inOutExpo, outInExpo, inCirc, outCirc, inOutCirc, outInCirc, inElastic,outElastic, inOutElastic, outInElastic, inBack, outBack, inOutBack, outInBack, inBounce, outBounce,inOutBounce, outInBounce = ease.linear, ease.inQuad, ease.outQuad, ease.inOutQuad, ease.outInQuad,ease.inCubic, ease.outCubic, ease.inOutCubic, ease.outInCubic, ease.inQuart, ease.outQuart,ease.inOutQuart, ease.outInQuart, ease.inQuint, ease.outQuint, ease.inOutQuint, ease.outInQuint,ease.inSine, ease.outSine, ease.inOutSine, ease.outInSine, ease.inExpo, ease.outExpo, ease.inOutExpo,ease.outInExpo, ease.inCirc, ease.outCirc, ease.inOutCirc, ease.outInCirc, ease.inElastic,ease.outElastic, ease.inOutElastic, ease.outInElastic, ease.inBack, ease.outBack, ease.inOutBack,ease.outInBack, ease.inBounce, ease.outBounce, ease.inOutBounce, ease.outInBounce

local perframe, mod_insert, mod2_insert, mod_ease, mod_perframe, mod_message, mod_blacklist, simple_m0d, simple_m0d2, simple_m0d3, mod_wiggle, mod_spring, mod_springt, mod_springt2, mod_spring_adjustable, mod_onebeat, switcfino_add, switcfino_reset, mod_sugarkiller, modulo, reverseRotation, randomXD, mod_bounce, ease_wiggle, ease_wiggleAbs = modhelpers.perframe, modhelpers.mod_insert, modhelpers.mod2_insert, modhelpers.mod_ease, modhelpers.mod_perframe, modhelpers.mod_message, modhelpers.mod_blacklist, modhelpers.simple_m0d, modhelpers.simple_m0d2, modhelpers.simple_m0d3, modhelpers.mod_wiggle, modhelpers.mod_spring, modhelpers.mod_springt, modhelpers.mod_springt2, modhelpers.mod_spring_adjustable, modhelpers.mod_onebeat, modhelpers.switcfino_add, modhelpers.switcfino_reset, modhelpers.mod_sugarkiller, modhelpers.modulo,modhelpers.reverseRotation, modhelpers.randomXD, modhelpers.mod_bounce, modhelpers.ease_wiggle, modhelpers.ease_wiggleAbs

local m = mod_insert
local m2 = mod_message
local me = mod_ease
local mb = mod_bounce
			
local l = 'len'
local e = 'end'

init_modsp1 = ''
init_modsp2 = ''

mod_plr = {}

mod_firstSeenBeat = GAMESTATE:GetSongBeat() --necessary to prevent long freezes

local poptions = {GAMESTATE:GetPlayerState(0):GetPlayerOptions('ModsLevel_Song'), GAMESTATE:GetPlayerState(1):GetPlayerOptions('ModsLevel_Song')}


---------------------------------------------------------------------------------------
----------------------Begin tables 'n stuff--------------------------------------------
---------------------------------------------------------------------------------------

--beat based mods
--{beat_start, beat_end, mods, len_or_end, player_number}
mods = {
	{0,9999,'*1000 no beat, *1000 no drunk, *1000 no tipsy, *1000 no invert, *1000 no flip, *1000 no dizzy','end'},
}
			
--this is both a message broadcaster and a function runner
--if you put {beat,'String'}, then 'String' is broadcast as a message on that beat
--if you put {beat,function() somecode end}, then function() is run at that beat
--see example on beat 32

curaction = 1
--{beat,thing,persists}
mod_actions = {


	
}
			
--beat-based ease mods
--{time_start, time_end, mod_start, mod_end, mod, len_or_end, ease_type, player_number, sustaintime, optional_param1, optional_param2}
--valid ease types are:
	--linear
	--inQuad    outQuad    inOutQuad    outInQuad
	--inCubic   outCubic   inOutCubic   outInCubic
	--inQuart   outQuart   inOutQuart   outInQuart
	--inQuint   outQuint   inOutQuint   outInQuint
	--inSine    outSine    inOutSine    outInSine
	--inExpo    outExpo    inOutExpo    outInExpo
	--inCirc    outCirc    inOutCirc    outInCirc
	--inElastic outElastic inOutElastic outInElastic    --can take 2 optional parameters - amplitude & period
	--inBack    outBack    inOutBack    outInBack       --can take 1 optional parameter  - spring amount
	--inBounce  outBounce  inOutBounce  outInBounce
	
mods_ease = {
	-- EXAMPLE TWEEN: from beat 0 to 4, make rotationz go from 360 to 0 with the inOutBack tween
	--{0,4,360,0,'rotationz','end',inOutBack},
}



mod_perframes = {
	
}

-- thank u ky dashiel
-- fixed by ??? for 5.1 because 100% Mini seems to be stored as 1.0 in poptions
local poptions = {GAMESTATE:GetPlayerState(0):GetPlayerOptions('ModsLevel_Song'), GAMESTATE:GetPlayerState(1):GetPlayerOptions('ModsLevel_Song')}
local isusingreverse = {false, false}
local miniscale = {1,1}
for pn = 1, 2 do
    if poptions[pn] then
        isusingreverse[pn] = poptions[pn]:Reverse() ~= 0
        miniscale[pn] = (2 - poptions[pn]:Mini()) * 0.5
    end
end

function pmini(value, pn)
	return poptions[pn]:Mini()*100 + value * miniscale[pn]
end

function pministr(value, pn)
	return pmini(value, pn) .. '% mini'
end

function prev(value, pn)
	if isusingreverse[pn] then
		return 100 - value
	else
		return value
	end
end

function prevstr(value, pn)
	return prev(value, pn) .. '% reverse'
end

-- negate alt, split, cross when in reverse
function pasc(value, pn)
	if isusingreverse[pn] then
		return -value
	else
		return value
	end
end

-- Copying spike function from Karachi thanks exschwasion and sorry
local function spike(beat, dur, pre, start, stop, mod, ease, preEase)
	preEase = preEase or inExpo
	me(beat - pre, pre, start, stop, mod, l, preEase)
	me(beat, dur, stop, start, mod, l, ease)
end

function mpf(s,e,f)
	table.insert(mod_perframes,{s,e,f})
end

local h = SCREEN_HEIGHT / 480

for pn = 1,2 do
	if GAMESTATE:IsPlayerEnabled(pn-1) then
		if GAMESTATE:GetCurrentSteps(pn-1):GetDifficulty() == 'Difficulty_Challenge' or GAMESTATE:GetCurrentSteps(pn-1):GetDifficulty() == 'Difficulty_Hard' then
			
			--	beat	len		(start/end)	mod			len (ease func) pn
			
			me(64, 3, 0, 10, 'invert', l, outCirc)
			me(64, 3, 0, -10, 'flip', l, outCirc)
			me(	65, 	0.5,	pasc(6.25), 0,	'cross', 	'len', outSine, pn)
			me(	65, 	0.5,	pasc(-6.25), 0,	'split', 	'len', outSine, pn)
			me(	65, 	0.5,	pasc(6.25), 0,	'alternate','len', outSine, pn)
			me(	66, 	0.5,	pasc(6.25), 0,	'cross', 	'len', outSine, pn)
			me(	66, 	0.5,	pasc(-6.25), 0,	'split', 	'len', outSine, pn)
			me(	66, 	0.5,	pasc(6.25), 0,	'alternate','len', outSine, pn)
			me(67, 1, 10, 0, 'invert', l, outElastic)
			me(67, 1, -10, 0, 'flip', l, outElastic)
			
			me(	180,	8,	0, -150,		'tiny', 'len', linear, pn)
			me(	180,	8,	0, 100,		'stealth', 'len', linear, pn)
			me(	180,	8,	0, 100,		'dark', 'len', linear, pn)
			
			me(	196,	4,	200, 0,		'tiny', 'len', outCubic, pn)
			me(	196,	4,	100, 0,		'stealth', 'len', outCubic, pn)
			me(	196,	4,	100, 0,		'dark', 'len', outCubic, pn)
			
			me(	240,	1,	-50, 0,		'tiny', 'len', outCubic, pn)
			me(	240,	1,	50, 0,		'stealth', 'len', outCubic, pn)
			me(	241.5,	1,	-50, 0,		'tiny', 'len', outCubic, pn)
			me(	241.5,	1,	50, 0,		'stealth', 'len', outCubic, pn)
			me(	243,	1,	-50, 0,		'tiny', 'len', outCubic, pn)
			me(	243,	1,	50, 0,		'stealth', 'len', outCubic, pn)
			me(	246,	1,	-50, 0,		'tiny', 'len', outCubic, pn)
			me(	246,	1,	50, 0,		'stealth', 'len', outCubic, pn)
			
			me(	276, 	0.5,	pasc(6.25), 0,	'split', 	'len', outSine, pn)
			me(	276, 	0.5,	pasc(-6.25), 0,	'cross', 	'len', outSine, pn)
			me(	276, 	0.5,	pasc(6.25), 0,	'alternate','len', outSine, pn)
			me(	277, 	0.5,	pasc(6.25), 0,	'split', 	'len', outSine, pn)
			me(	277, 	0.5,	pasc(-6.25), 0,	'cross', 	'len', outSine, pn)
			me(	277, 	0.5,	pasc(6.25), 0,	'alternate','len', outSine, pn)
			me(	278, 	0.5,	pasc(6.25), 0,	'split', 	'len', outSine, pn)
			me(	278, 	0.5,	pasc(-6.25), 0,	'cross', 	'len', outSine, pn)
			me(	278, 	0.5,	pasc(6.25), 0,	'alternate','len', outSine, pn)
			
			-- Hardstyle section
			for b = 0, 5 do
				me(344+b,	1,	-30, 0,		'tiny', 'len', outCubic, pn)
				me(344+b,	1,	10, 0,		'flip', 'len', outCubic, pn)
				--me(	375,	1,	50, 0,		'stealth', 'len', outCubic, pn)
			end
			
			for b = 0, 1.5, 0.5 do
				me(350+b,	1,	-30, 0,		'tiny', 'len', outCubic, pn)
				me(350+b,	1,	10, 0,		'flip', 'len', outCubic, pn)
				--me(	375,	1,	50, 0,		'stealth', 'len', outCubic, pn)
			end
			
			for b = 0, 3 do
				me(352+b,	1,	-30, 0,		'tiny', 'len', outCubic, pn)
				me(352+b,	1,	10, 0,		'flip', 'len', outCubic, pn)
				--me(	375,	1,	50, 0,		'stealth', 'len', outCubic, pn)
			end
			
			for b = 0, 1, 0.5 do
				me(356+b,	1,	-30, 0,		'tiny', 'len', outCubic, pn)
				me(356+b,	1,	10, 0,		'flip', 'len', outCubic, pn)
				--me(	375,	1,	50, 0,		'stealth', 'len', outCubic, pn)
			end
			
			me(358,	1,	-30, 0,		'tiny', 'len', outCubic, pn)
			me(358,	1,	10, 0,		'flip', 'len', outCubic, pn)
			me(358.5,	1,	-30, 0,		'tiny', 'len', outCubic, pn)
			me(358.5,	1,	10, 0,		'flip', 'len', outCubic, pn)
			me(358.75,	1,	-30, 0,		'tiny', 'len', outCubic, pn)
			me(358.75,	1,	10, 0,		'flip', 'len', outCubic, pn)
			
			for b = 0, 6 do
				me(368+b,	1,	-30, 0,		'tiny', 'len', outCubic, pn)
				me(368+b,	1,	10, 0,		'flip', 'len', outCubic, pn)
				--me(	375,	1,	50, 0,		'stealth', 'len', outCubic, pn)
			end
			
			me(	375,	1,	-50, 0,		'tiny', 'len', outCubic, pn)
			me(	375,	1,	50, 0,		'stealth', 'len', outCubic, pn)
			
			for i = 0, 5 do
					spike(393+i, 0.8, 0.2, 0, -30, 'tiny', outCubic)
					spike(393+i, 0.8, 0.2, 0, -60 * (i%2*2-1), 'tipsy', outCubic)
			end
			
			for i = 0, 2 do
					spike(401+i, 0.8, 0.2, 0, -30, 'tiny', outCubic)
					spike(401+i, 0.8, 0.2, 0, -60 * (i%2*2-1), 'tipsy', outCubic)
			end
			
			for i = 0, 3 do
				m(399 + 0.25 * i, 0.25, '*10000 '.. -628 * (3 - i)/4 .. ' confusionoffset')
				me(399 + 0.25 * i, 0.25, -50 * (4 - i)/4, -50 * (3 - i)/4, 'tiny', l, outExpo)
				me(399 + 0.25 * i, 0.25, -10 * (4 - i)/4, -10 * (3 - i)/4, 'flip', l, outExpo)
				me(399 + 0.25 * i, 0.25, 40 * (i%2*2-1), 0, 'tipsy', l, outCirc)
			end
			
			me(	436, 	0.5,	pasc(6.25), 0,	'split', 	'len', outSine, pn)
			me(	436, 	0.5,	pasc(-6.25), 0,	'cross', 	'len', outSine, pn)
			me(	436, 	0.5,	pasc(6.25), 0,	'alternate','len', outSine, pn)
			me(	437, 	0.5,	pasc(6.25), 0,	'split', 	'len', outSine, pn)
			me(	437, 	0.5,	pasc(-6.25), 0,	'cross', 	'len', outSine, pn)
			me(	437, 	0.5,	pasc(6.25), 0,	'alternate','len', outSine, pn)
			me(	438, 	0.5,	pasc(6.25), 0,	'split', 	'len', outSine, pn)
			me(	438, 	0.5,	pasc(-6.25), 0,	'cross', 	'len', outSine, pn)
			me(	438, 	0.5,	pasc(6.25), 0,	'alternate','len', outSine, pn)
			
			m(	439,		16.5,					'*1 50% tiny', 'len', pn)
			m(	439,		16.5,					'*1 50% drunk', 'len', pn)
			
			--me(	455.5,	0.25,	50, 0,		'mini', 'len', linear, pn)
			m(	455.5,		0.25,					'*4 0% drunk', 'len', pn)
			m(	455.5,		0.25,					'*4 0% tiny', 'len', pn)
			
		end
		if GAMESTATE:GetCurrentSteps(pn-1):GetDifficulty() == 'Difficulty_Challenge' then
			for i = 0, 27 do
				mb(616 + i, 1, 0, 10, 'brake', outCirc, inQuad)
				me(616 + i, 1, -30, 0, 'tiny', l, outQuad)
			end
		end
	end
end



function modtable_compare(a,b)
	return a[1] < b[1]
end

if table.getn(mod_actions) > 1 then
	table.sort(mod_actions, modtable_compare)
end

local ac = Def.ActorFrame{
	Name= "xtl_actor_d",
	Def.Actor{ OnCommand= function(s) mod_firstSeenBeat = GAMESTATE:GetSongBeat() s:sleep(9e9) end },
	Def.Actor{ InitCommand= function(s) my_auxvar = s end,
	},
	
	-- Intro texts
	Def.Sprite{
		Name="Intro1";
		Texture="texts/intro-text1.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		Intro1Command=function(self)
			self:visible(1)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:zoomy(0.5)
			self:zoomx(1)
			self:decelerate(0.25)
			self:zoomx(0.5)
		end;
		Intro1LeavesCommand=function(self)
			self:linear(TimeInBeats(1,200))
			self:diffusealpha(0)
		end;
	};
	
	Def.Sprite{
		Name="Intro2";
		Texture="texts/intro-text2.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		Intro2Command=function(self)
			self:visible(1)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:zoomy(0.5)
			self:zoomx(1)
			self:decelerate(0.25)
			self:zoomx(0.5)
		end;
		Intro2LeavesCommand=function(self)
			self:linear(TimeInBeats(1,200))
			self:diffusealpha(0)
		end;
	};
	
	Def.Sprite{
		Name="Intro3";
		Texture="texts/intro-text3.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		Intro3Command=function(self)
			self:visible(1)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:zoomy(0.5)
			self:zoomx(1)
			self:decelerate(0.25)
			self:zoomx(0.5)
		end;
		Intro3LeavesCommand=function(self)
			self:linear(TimeInBeats(1,200))
			self:diffusealpha(0)
		end;
	};
	
	--All the music genres stuff goes here
	--Really scruff but mostly because I didn't have time to optimize due to dimocracy timelines lol
	Def.Sprite{
		Name="Hardtek";
		Texture="texts/Hardtek-text.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		HardtekCommand=function(self)
			self:visible(1)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:zoomy(0.5)
			self:zoomx(1)
			self:decelerate(0.25)
			self:zoomx(0.5)
		end;
		HardtekLeavesCommand=function(self)
			self:linear(TimeInBeats(1,200))
			self:diffusealpha(0)
		end;
	};
	
	Def.Sprite{
		Name="Frenchcore";
		Texture="texts/Frenchcore-text.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		FrenchcoreCommand=function(self)
			self:visible(1)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:zoomy(0.5)
			self:zoomx(1)
			self:decelerate(0.25)
			self:zoomx(0.5)
		end;
		FrenchcoreLeavesCommand=function(self)
			self:linear(TimeInBeats(1,200))
			self:diffusealpha(0)
		end;
	};
	
	Def.Sprite{
		Name="Artcore";
		Texture="texts/Artcore-text.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		ArtcoreCommand=function(self)
			self:visible(1)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:zoomy(0.5)
			self:zoomx(1)
			self:decelerate(0.25)
			self:zoomx(0.5)
		end;
		ArtcoreLeavesCommand=function(self)
			self:linear(TimeInBeats(1,200))
			self:diffusealpha(0)
		end;
	};
	
	Def.Sprite{
		Name="Metal";
		Texture="texts/Metal-text.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		MetalCommand=function(self)
			self:visible(1)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:zoomy(0.5)
			self:zoomx(1)
			self:decelerate(0.25)
			self:zoomx(0.5)
		end;
		MetalLeavesCommand=function(self)
			self:linear(TimeInBeats(1,200))
			self:diffusealpha(0)	
		end;
	};
	
	Def.Sprite{
		Name="WhiteFade";
		Texture="gfx/whitebghd.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		WhiteBGCommand=function(self)
			self:visible(1)
			self:diffusealpha(0)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:zoom(100)
			self:linear(TimeInBeats(8,200))
			self:diffusealpha(1)
		end;
		WhiteBG2Command=function(self)
			self:visible(1)
			self:diffusealpha(0)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:zoomx(100)
			self:zoomy(100)
			self:linear(TimeInBeats(24,200))
			self:diffusealpha(1)
		end;
		WhiteBGLeavesCommand=function(self)
			self:linear(TimeInBeats(4,200))
			self:diffusealpha(0)
		end;
		WhiteBGLeaves2Command=function(self)
			self:linear(TimeInBeats(8,200))
			self:diffusealpha(0)
		end;
	};
	
	Def.Sprite{
		Name="WhiteFlash";
		Texture="gfx/whitebghd.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		WhiteFlashCommand=function(self)
			self:visible(1)
			self:diffusealpha(1)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:zoom(100)
			self:linear(TimeInBeats(4,200))
			self:diffusealpha(0)
		end;
	};
	
	Def.Sprite{
		Name="BlackScreen";
		Texture="gfx/blackbghd.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		BlackScreenCommand=function(self)
			self:visible(1)
			self:diffusealpha(0)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:setsize(SCREEN_WIDTH, SCREEN_HEIGHT)
			self:linear(TimeInBeats(4,200))
			self:diffusealpha(1)
		end;
	};
	
	Def.Sprite{
		Name="Complextro";
		Texture="texts/Complextro-text.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		ComplextroCommand=function(self)
			self:visible(1)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:zoomy(0.5)
			self:zoomx(1)
			self:decelerate(0.25)
			self:zoomx(0.5)
		end;
		ComplextroLeavesCommand=function(self)
			self:linear(TimeInBeats(1,132))
			self:diffusealpha(0)
		end;
	};
	
	Def.Sprite{
		Name="MelodicProgessiveHouse";
		Texture="texts/MelodicProgessiveHouse-text.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		MelodicProgessiveHouseCommand=function(self)
			self:visible(1)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:zoomy(0.5)
			self:zoomx(1)
			self:decelerate(0.25)
			self:zoomx(0.5)
		end;
		MelodicProgessiveHouseLeavesCommand=function(self)
			self:linear(TimeInBeats(1,132))
			self:diffusealpha(0)
		end;
	};
	
	Def.Sprite{
		Name="Trance";
		Texture="texts/Trance-text.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		TranceCommand=function(self)
			self:visible(1)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:zoomy(0.5)
			self:zoomx(1)
			self:decelerate(0.25)
			self:zoomx(0.5)
		end;
		TranceLeavesCommand=function(self)
			self:linear(TimeInBeats(1,140))
			self:diffusealpha(0)
		end;
	};
	
	Def.Sprite{
		Name="PsychedelicTrance";
		Texture="texts/PsychedelicTrance-text.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		PsychedelicTranceCommand=function(self)
			self:visible(1)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:zoomy(0.5)
			self:zoomx(1)
			self:decelerate(0.25)
			self:zoomx(0.5)
		end;
		PsychedelicTranceLeavesCommand=function(self)
			self:linear(TimeInBeats(1,150))
			self:diffusealpha(0)
		end;
	};
	
	Def.Sprite{
		Name="Hardstyle";
		Texture="texts/Hardstyle-text.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		HardstyleCommand=function(self)
			self:visible(1)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:zoomy(0.5)
			self:zoomx(1)
			self:decelerate(0.25)
			self:zoomx(0.5)
		end;
		HardstyleLeavesCommand=function(self)
			self:linear(TimeInBeats(1,150))
			self:diffusealpha(0)
		end;
	};
	
	Def.Sprite{
		Name="Psystyle";
		Texture="texts/Psystyle-text.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		PsystyleCommand=function(self)
			self:visible(1)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:zoomy(0.5)
			self:zoomx(1)
			self:decelerate(0.25)
			self:zoomx(0.5)
		end;
		PsystyleLeavesCommand=function(self)
			self:linear(TimeInBeats(1,150))
			self:diffusealpha(0)
		end;
	};
	
	Def.Sprite{
		Name="Dubstep";
		Texture="texts/Dubstep-text.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		DubstepCommand=function(self)
			self:visible(1)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:zoomy(0.5)
			self:zoomx(1)
			self:decelerate(0.25)
			self:zoomx(0.5)
		end;
		DubstepLeavesCommand=function(self)
			self:linear(TimeInBeats(1,150))
			self:diffusealpha(0)
		end;
	};
	
	Def.Sprite{
		Name="ColourBass";
		Texture="texts/ColourBass-text.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		ColourBassCommand=function(self)
			self:visible(1)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:zoomy(0.5)
			self:zoomx(1)
			self:decelerate(0.25)
			self:zoomx(0.5)
		end;
		ColourBassLeavesCommand=function(self)
			self:linear(TimeInBeats(1,150))
			self:diffusealpha(0)
		end;
	};
	
	Def.Sprite{
		Name="HiTechFullOn";
		Texture="texts/HiTechFullOn-text.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		HiTechFullOnCommand=function(self)
			self:visible(1)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:zoomy(0.5)
			self:zoomx(1)
			self:decelerate(0.25)
			self:zoomx(0.5)
		end;
		HiTechFullOnLeavesCommand=function(self)
			self:linear(TimeInBeats(1,160))
			self:diffusealpha(0)
		end;
	};
	
	Def.Sprite{
		Name="JukeFootwork";
		Texture="texts/JukeFootwork-text.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		JukeFootworkCommand=function(self)
			self:visible(1)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:zoomy(0.5)
			self:zoomx(1)
			self:decelerate(0.25)
			self:zoomx(0.5)
		end;
		JukeFootworkLeavesCommand=function(self)
			self:linear(TimeInBeats(1,160))
			self:diffusealpha(0)
		end;
	};
	
	Def.Sprite{
		Name="LofiHipHop";
		Texture="texts/LofiHipHop-text.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		LofiHipHopCommand=function(self)
			self:visible(1)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:zoomy(0.5)
			self:zoomx(1)
			self:decelerate(0.25)
			self:zoomx(0.5)
		end;
		LofiHipHopLeavesCommand=function(self)
			self:linear(TimeInBeats(1,160))
			self:diffusealpha(0)
		end;
	};
	
	Def.Sprite{
		Name="KawaiiFutureBass";
		Texture="texts/KawaiiFutureBass-text.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		KawaiiFutureBassCommand=function(self)
			self:visible(1)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:zoomy(0.5)
			self:zoomx(1)
			self:decelerate(0.25)
			self:zoomx(0.5)
		end;
		KawaiiFutureBassLeavesCommand=function(self)
			self:linear(TimeInBeats(1,170))
			self:diffusealpha(0)
		end;
	};
	
	Def.Sprite{
		Name="Drumstep";
		Texture="texts/Drumstep-text.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		DrumstepCommand=function(self)
			self:visible(1)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:zoomy(0.5)
			self:zoomx(1)
			self:decelerate(0.25)
			self:zoomx(0.5)
		end;
		DrumstepLeavesCommand=function(self)
			self:linear(TimeInBeats(1,180))
			self:diffusealpha(0)
		end;
	};
	
	Def.Sprite{
		Name="Hardcore";
		Texture="texts/Hardcore-text.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		HardcoreCommand=function(self)
			self:visible(1)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y);
			self:zoomy(0.5)
			self:zoomx(1)
			self:decelerate(0.25)
			self:zoomx(0.5)
		end;
		HardcoreLeavesCommand=function(self)
			self:linear(TimeInBeats(1,200))
			self:diffusealpha(0)
		end;
	};
	
	--BPM sprites 
	Def.Sprite{
		Name="BPM200";
		Texture="texts/BPM200.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		BPM200Command=function(self)
			self:visible(1)
			self:diffusealpha(1)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y+35);
			self:zoomy(0.5)
			self:zoomx(1)
			self:decelerate(0.25)
			self:zoomx(0.5)
		end;
		BPM200LeavesCommand=function(self)
			self:linear(TimeInBeats(1,200))
			self:diffusealpha(0)
		end;
	};
	
	Def.Sprite{
		Name="BPM132";
		Texture="texts/BPM132.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		BPM132Command=function(self)
			self:visible(1)
			self:diffusealpha(1)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y+35);
			self:zoomy(0.5)
			self:zoomx(1)
			self:decelerate(0.25)
			self:zoomx(0.5)
		end;
		BPM132MelodicCommand=function(self)
			self:diffusealpha(1)
			self:visible(1)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y+60);
			self:zoomy(0.5)
			self:zoomx(1)
			self:decelerate(0.25)
			self:zoomx(0.5)
		end;
		BPM132LeavesCommand=function(self)
			self:linear(TimeInBeats(1,132))
			self:diffusealpha(0)
		end;
	};
	
	Def.Sprite{
		Name="BPM140";
		Texture="texts/BPM140.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		BPM140Command=function(self)
			self:visible(1)
			self:diffusealpha(1)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y+35);
			self:zoomy(0.5)
			self:zoomx(1)
			self:decelerate(0.25)
			self:zoomx(0.5)
		end;
		BPM140LeavesCommand=function(self)
			self:linear(TimeInBeats(1,140))
			self:diffusealpha(0)
		end;
	};
	
	Def.Sprite{
		Name="BPM150";
		Texture="texts/BPM150.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		BPM150Command=function(self)
			self:visible(1)
			self:diffusealpha(1)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y+35);
			self:zoomy(0.5)
			self:zoomx(1)
			self:decelerate(0.25)
			self:zoomx(0.5)
		end;
		BPM150LeavesCommand=function(self)
			self:linear(TimeInBeats(1,150))
			self:diffusealpha(0)
		end;
	};
	
	Def.Sprite{
		Name="BPM150Black";
		Texture="texts/BPM150Black.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		BPM150BlackCommand=function(self)
			self:visible(1)
			self:diffusealpha(1)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y+35);
			self:zoomy(0.5)
			self:zoomx(1)
			self:decelerate(0.25)
			self:zoomx(0.5)
		end;
		BPM150BlackLeavesCommand=function(self)
			self:linear(TimeInBeats(1,150))
			self:diffusealpha(0)
		end;
	};
	
	Def.Sprite{
		Name="BPM160";
		Texture="texts/BPM160.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		BPM160Command=function(self)
			self:visible(1)
			self:diffusealpha(1)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y+35);
			self:zoomy(0.5)
			self:zoomx(1)
			self:decelerate(0.25)
			self:zoomx(0.5)
		end;
		BPM160LeavesCommand=function(self)
			self:linear(TimeInBeats(1,160))
			self:diffusealpha(0)
		end;
	};
	
	Def.Sprite{
		Name="BPM80";
		Texture="texts/BPM80.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		BPM80Command=function(self)
			self:visible(1)
			self:diffusealpha(1)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y+35);
			self:zoomy(0.5)
			self:zoomx(1)
			self:decelerate(0.25)
			self:zoomx(0.5)
		end;
		BPM80LeavesCommand=function(self)
			self:linear(TimeInBeats(1,160))
			self:diffusealpha(0)
		end;
	};
	
	Def.Sprite{
		Name="BPM170";
		Texture="texts/BPM170.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		BPM170Command=function(self)
			self:visible(1)
			self:diffusealpha(1)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y+35);
			self:zoomy(0.5)
			self:zoomx(1)
			self:decelerate(0.25)
			self:zoomx(0.5)
		end;
		BPM170LeavesCommand=function(self)
			self:linear(TimeInBeats(1,170))
			self:diffusealpha(0)
		end;
	};
	
	Def.Sprite{
		Name="BPM180";
		Texture="texts/BPM180.png";
		OnCommand=function(self)
			self:visible(0)
		end;
		BPM180Command=function(self)
			self:visible(1)
			self:diffusealpha(1)
			self:xy(SCREEN_CENTER_X,SCREEN_CENTER_Y+35);
			self:zoomy(0.5)
			self:zoomx(1)
			self:decelerate(0.25)
			self:zoomx(0.5)
		end;
		BPM180LeavesCommand=function(self)
			self:linear(TimeInBeats(1,180))
			self:diffusealpha(0)
		end;
	};
	
	InitCommand = function (self)

		self:SetDrawByZPosition(true)
		-- table to keep track of mods already finished
		local completed = {}


		for _, mod in ipairs(LuaMods) do
		  local beat = unpack(mod)
		  if GAMESTATE:GetSongBeat() > beat then
			completed[mod] = true
		  end
		end



		-- hOBOI
		self:SetUpdateFunction(function()
		  MESSAGEMAN:Broadcast("Update")
		  local curbeat = GAMESTATE:GetSongBeat()
		  local circlepos = curbeat / 2 * math.pi


		  -- this is significantly easier *sigh*
		  for _, mod in ipairs(LuaMods) do
			local beat, command = unpack(mod)
			if curbeat > beat and not completed[mod] then
			  self:playcommand(command, unpack(mod, 3))
			  completed[mod] = true
			end
		  end
		end)
    end;

    OnCommand=function(self)

    self:SetDrawByZPosition(true)

    -- keep the FG change alive
    self:sleep(9999)
    end;
	
	Def.Actor{
		
		OnCommand=function(s)
			s:queuecommand('Update')
		end,
		UpdateCommand=function(self)
			
			if GAMESTATE:GetSongBeat()>=0 and not checked then
			
				--name players, judgment and combo
				for pn=1,2 do
					_G['P'..pn] = SCREENMAN:GetTopScreen():GetChild('PlayerP'..pn) or nil
					if _G['P'..pn] then
						_G['jud'..pn] = _G['P'..pn]:GetChild('Judgment')
						_G['com'..pn] = _G['P'..pn]:GetChild('Combo')
					end
					
				end
				
				screen = SCREENMAN:GetTopScreen()
				checked = true --let this only run once
				
			end

			local beat = GAMESTATE:GetSongBeat()
			
			
---------------------------------------------------------------------------------------
----------------------Begin table handlers---------------------------------------------
---------------------------------------------------------------------------------------
			
			disable = false
			if disable ~= true and beat > mod_firstSeenBeat+0.1 and checked then
				
				-----------------------
				-- Player mod resets --
				-----------------------
				for i=1,2 do
					--mod_do('clearall',i)
				end
				
				------------------------------------------------------------------------------
				-- custom mod reader by TaroNuke edited by WinDEU and re-stolen by TaroNuke --
				------------------------------------------------------------------------------
				for i,v in pairs(mods) do
					if v and table.getn(v) > 3 and v[1] and v[2] and v[3] and v[4] then
						if beat >=v[1] then
							if (v[4] == 'len' and beat <=v[1]+v[2]) or (v[4] == 'end' and beat <=v[2]) then
								if table.getn(v) == 5 then
									mod_do(v[3],v[5])
								else
									mod_do(v[3])
								end
							end
						end
					else
						v[1] = 0
						v[2] = 0
						v[3] = ''
						v[4] = 'error'
						SCREENMAN:SystemMessage('Bad mod in beat-based table (line '..i..')')
					end
				end
				
				--------------------------------------------------------------------------------------
				-- i dont know who this reader is but he looks like he is made out of EASE HAHAHAHA --
				-- original code by exschwasion, bastardized by taro for cmod support and less 'if' --
				--------------------------------------------------------------------------------------
				for i,v in pairs(mods_ease) do
					if v and table.getn(v) > 6 and v[1] and v[2] and v[3] and v[4] and v[5] and v[6] and v[7] then
						if beat >=v[1] then
							if (v[6] == 'len' and beat <=v[1]+v[2]) or (v[6] == 'end' and beat <=v[2]) then
								
								local duration = v[2]
								if v[6] == 'end' then duration = v[2] - v[1] end
								local curtime = beat - v[1]
								local diff = v[4] - v[3]
								local startstrength = v[3]
								local curve = v[7]
								local mod = v[5]
								
								local strength = curve(curtime, startstrength, diff, duration, v[10], v[11]) --extra parameters for back and elastic eases :eyes:
								
								if type(mod) == 'function' then
									mod(strength)
								else
									local modstr = v[5] == 'xmod' and strength..'x' or (v[5] == 'cmod' and 'C'..strength or strength..' '..v[5])
									mod_do('*10000 '..modstr,v[8]);
								end
								
							elseif (v[9] and ((v[6] == 'len' and beat <=v[1]+v[2]+v[9]) or (v[6] == 'end' and beat <=v[9]))) then
							
								local strength = v[4]
								if type(mod) == 'function' then
									mod(strength)
								else
									local modstr = v[5] == 'xmod' and strength..'x' or (v[5] == 'cmod' and 'C'..strength or strength..' '..v[5])
									mod_do('*10000 '..modstr,v[8]);
								end
								
							end
						end
					else
						SCREENMAN:SystemMessage('Bad mod in beat-based ease table (line '..i..')')
					end
				end
				
				--------------------
				-- Perframe stuff --
				--------------------
				
				----------------------------------------
				-- HBLBHCBLBJGBHL DO THIS EVERY FRAME --
				----------------------------------------
				
				if table.getn(mod_perframes)>0 then
					for i=1,table.getn(mod_perframes) do
						local a = mod_perframes[i]
						if beat > a[1] and beat < a[2] then
							a[3](beat)
						end
					end
				end
				
				---------------------------------------
				-- ACTION RPGS AINT GOT SHIT ON THIS --
				---------------------------------------
				while curaction<=table.getn(mod_actions) and GAMESTATE:GetSongBeat()>=mod_actions[curaction][1] do
					if mod_actions[curaction][3] or GAMESTATE:GetSongBeat() < mod_actions[curaction][1]+2 then
						if type(mod_actions[curaction][2]) == 'function' then
							mod_actions[curaction][2]()
						elseif type(mod_actions[curaction][2]) == 'string' then
							MESSAGEMAN:Broadcast(mod_actions[curaction][2])
						end
					end
					curaction = curaction+1
				end
				
			end
			
			self:sleep(1/FRAME_RATE)
			self:queuecommand('Update')

---------------------------------------------------------------------------------------
----------------------END DON'T TOUCH IT KIDDO-----------------------------------------
---------------------------------------------------------------------------------------
			
		end,
	
	}
}

return ac